// Scroll script

// Element reading bar
const readingBar = document.querySelector('.reading__bar');

// Element secondary bar
let secondaryBar = document.querySelector('.secondary-bar');

// Element header fixed
let headerFixed = document.querySelector('.header-fixed');
// Heights header and secondary
let secondaryBarHeight = parseInt(getComputedStyle(secondaryBar).height);
let headerFixedHeight = parseInt(getComputedStyle(headerFixed).height);



// Scroll evevnt
.addEventListener('scroll', () => {
	// Document height
	const documentHeight = document.documentElement.scrollHeight;
	// Position scroll in Y
	const scrollPosition = document.documentElement.scrollTop;

	// Change height secondary bar
	secondaryBar.style.height = `${scrollPosition > 0 ? `${0}px` : ''}`;
	// Change header fixed bar
	headerFixed.style.height = `${scrollPosition > 0 ? `${(headerFixedHeight - secondaryBarHeight)}px` : ''}`;

	// Calculate width reading bar
	readingBar.style.width = `${scrollPosition === 0 ? 0 : (scrollPosition / documentHeight).toFixed(2) * 100 + 3}%`;
});

// Event change  width
.addEventListener('resize', () => {
	secondaryBar = document.querySelector('.secondary-bar');
	headerFixed = document.querySelector('.header-fixed');
	// Change value heights header and secondary
	secondaryBarHeight = parseInt(getComputedStyle(secondaryBar).height);
	headerFixedHeight = parseInt(getComputedStyle(headerFixed).height);
});

// End scroll script