/* 
const comments = [
  {
    name: string,
    replyName: string (manually set name for reply, by default - dynamically sets previous name),
    ava: string (src to avatar img),
    likes: integer (manually set likes, by default - dynamically increments for each comment),
    text: string,
    imgTextSrc: string (src to img, wrapped with "lightbox"),
    imgTextSize: "big" || "small" (default - "big"; big - max-w=500px, small - max-w=250px),
    replies: [comments]
  },
  ...
] 

new CommentRenderer(".comment-content").render([
    {
        name: "Salta_Retiro",
        ava: "./assets/img/image2.webp",
        text: "My husband is a financial analyst and ...",
    },
    ...
]);
*/

//  THIS CLASS WORKS ONLY FOR - comments where child comments nested in parent AND B.T. COMMENTS like in 29357

class CommentRenderer {
  constructor(containerSelector, config = {}) {
    this.container = document.querySelector(containerSelector);
    this.config = {
      defaultAvatar: config.defaultAvatar || "",
      textImgSmallSize: parseInt(config.textImgSmallSize) || 250,
      textImgBigSize: parseInt(config.textImgBigSize) || 500,
    };
    this.lastParentLikes = 2;
    this.lastChildLikes;
  }

  rand(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
  }

  getLikes(likes, isChild) {
    if (likes) return likes;
    if (!isChild) {
      this.lastChildLikes = 0;
      return (this.lastParentLikes += this.rand(2, 4));
    }
    if (!this.lastChildLikes) {
      this.lastChildLikes = Math.max(
        this.lastParentLikes - this.rand(5, 10),
        1
      );
    } else {
      this.lastChildLikes -= Math.max(this.rand(5, 10), 1);
    }
    return this.lastChildLikes;
  }

  getImgBlock(src, size = "big", unicID) {
    if (!src) return "";
    const maxW =
      size === "small"
        ? this.config.textImgSmallSize + "px"
        : this.config.textImgBigSize + "px";
    return `
        <a href="${src}" class="lightbox-img" data-fslightbox="${unicID}" style="display: block; max-width: ${maxW}; margin-top: 10px;">
            <img src="${src}" alt="" class="lightbox-img" />
        </a>`;
  }
  getCommentHtml(className, avatar, author, text, likes, timeFn, replies) {
    return `
    <div class="${className}">
        <img src="${avatar}" alt="" class="fb-comment__avatar flux_cta"/>
        <div class="fb-comment__content">
            <div class="fb-comment__text">
                <span class="fb-comment__author flux_cta">${author}</span>
                <br />
                ${text}
                <div class="fb-comment__like">
                <a href="{{link}}" target="_blank" class="flux_cta"><img src="https://aio-tech.ams3.digitaloceanspaces.com/production/landing-cdn/666/082a07ad-8dcc-4227-bcaf-f96d3104f3f9/assets/comments/like.webp" class="flux_cta"/></a>
                ${likes}
            </div>
        </div>
        <div>
            <a class="fb-comment__react flux_cta" href="{{link}}" target="_blank">Mi piace</a>
            <a class="fb-comment__react flux_cta" href="{{link}}" target="_blank">Risposta</a>
            <span class="fb-comment__posted" data-time-function="${timeFn}"></span>
        </div>
        ${replies}
        </div>
    </div>`;
  }
  renderComment({
    isChild = false,
    ava = this.config.defaultAvatar,
    name,
    text,
    imgTextSrc,
    imgTextSize,
    likes,
    replies = [],
  }) {
    const className = isChild ? "fb-comment__answer" : "fb-comment__item";
    const timeFn = isChild ? "timeAnswerHoursAgo" : "timeHoursAgo";
    const likeCount = this.getLikes(likes, isChild);
    const textHtml =
      text + this.getImgBlock(imgTextSrc, imgTextSize, likeCount);
    const repliesHTML = replies
      .map((reply) => this.renderComment({ ...reply, isChild: true }))
      .join("");

    return this.getCommentHtml(
      className,
      ava,
      name,
      textHtml,
      likeCount,
      timeFn,
      repliesHTML
    );
  }

  render(comments) {
    comments.forEach((comment) =>
      this.container.insertAdjacentHTML(
        "beforeend",
        this.renderComment(comment)
      )
    );
  }
}

(function commentsCounter() {
  const comments = document.querySelectorAll(".comment-block");
  document
    .querySelectorAll("[data-js-comment-counter]")
    .forEach((n) => (n.textContent = comments.length));
})();